﻿using System;
using System.ComponentModel;
using System.Globalization;
using System.Runtime.InteropServices;
using System.Threading;
using System.Windows.Forms;
using System.Data;

namespace PsgBase
{
    [ComVisible(false)]
    public class psgDateTime : System.Windows.Forms.DateTimePicker
    {
        #region Fields / Constructors

        // true, when no date shall be displayed (empty DateTimePicker)
        private bool _isNull;

        // If _isNull = true, this value is shown in the DTP
        private string _nullValue;

        // The format of the DateTimePicker control
        private DateTimePickerFormat _format = DateTimePickerFormat.Long;

        // The custom format of the DateTimePicker control
        private string _customFormat;

        // The format of the DateTimePicker control as string
        private string _formatAsString;

        public DateTime? initial_value;
        string valueKey = string.Empty;
        string fieldKey = string.Empty;
        string fieldName = string.Empty;
        string servertablename = string.Empty;
        string fieldType;
        bool notNull = false;
        DataTable table;
        int hmn_loop;
        public bool isNull = false, isModified = false;
        public bool bControl = true;
        private bool saveType;

        public void InitializeComponent()
        {
            this.SuspendLayout();
            // 
            // psgDateTime
            // 
            this.CustomFormat = "dd.MM.yyyy HH:mm:ss";
            this.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
            this.CloseUp += new System.EventHandler(this.psgDateTime_CloseUp);
            this.ValueChanged += new System.EventHandler(this.psgdatetime_ValueChanged);
            this.DropDown += new System.EventHandler(this.psgDateTime_DropDown);
            this.Enter += new System.EventHandler(this.psgedit_Enter);
            this.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.psgedit_KeyPress);
            this.Validating += new System.ComponentModel.CancelEventHandler(this.psgDateTime_Validating);
            this.ResumeLayout(false);

        }

        public psgDateTime()
            : base()
        {
            InitializeComponent();
            base.Format = DateTimePickerFormat.Custom;
            NullValue = " ";
            Format = DateTimePickerFormat.Long;
        }

        #endregion

        #region Public properties

        /// <summary>
        /// Gets or sets the date/time value assigned to the control.
        /// </summary>
        /// <value>The DateTime value assigned to the control
        /// </value>
        /// <remarks>
        /// <p>If the <b>Value</b> property has not been changed in code or by the user, it is set
        /// to the current date and time (<see cref="DateTime.Now"/>).</p>
        /// <p>If <b>Value</b> is <b>null</b>, the DateTimePicker shows 
        /// <see cref="NullValue"/>.</p>
        /// </remarks>
        [Bindable(true)]
        [Browsable(true)]
        public new Object Value
        {
            get
            {
                if (_isNull)
                    return null;
                else
                    return base.Value;
            }
            set
            {
                if (value == null || value == DBNull.Value || Convert.ToDateTime(value).Year == 1)
                {
                    SetToNullValue();
                }
                else
                {
                    if (Convert.ToDateTime(value) == Utils.NullDateTime)
                    {
                        SetToNullValue();
                        base.Value = (DateTime)value;
                    }
                    else
                    {
                        SetToDateTimeValue();
                        base.Value = (DateTime)value;
                    }
                }
            }
        }

        /// <summary>
        /// Gets or sets the format of the date and time displayed in the control.
        /// </summary>
        /// <value>One of the <see cref="DateTimePickerFormat"/> values. The default is 
        /// <see cref="DateTimePickerFormat.Long"/>.</value>
        [Browsable(true)]
        [DefaultValue(DateTimePickerFormat.Long), TypeConverter(typeof(Enum))]
        public new DateTimePickerFormat Format
        {
            get { return _format; }
            set
            {
                _format = value;
                if (!_isNull)
                    SetFormat();
                OnFormatChanged(EventArgs.Empty);
            }
        }

        /// <summary>
        /// Gets or sets the custom date/time format string.
        /// <value>A string that represents the custom date/time format. The default is a null
        /// reference (<b>Nothing</b> in Visual Basic).</value>
        /// </summary>
        public new String CustomFormat
        {
            get { return _customFormat; }
            set { _customFormat = value; }
        }

        /// <summary>
        /// Gets or sets the string value that is assigned to the control as null value. 
        /// </summary>
        /// <value>The string value assigned to the control as null value.</value>
        /// <remarks>
        /// If the <see cref="Value"/> is <b>null</b>, <b>NullValue</b> is
        /// shown in the <b>DateTimePicker</b> control.
        /// </remarks>
        [Browsable(true)]
        [Category("Behavior")]
        [Description("The string used to display null values in the control")]
        [DefaultValue(" ")]
        public String NullValue
        {
            get { return _nullValue; }
            set { _nullValue = value; }
        }
        #endregion

        #region Private methods/properties
        /// <summary>
        /// Stores the current format of the DateTimePicker as string. 
        /// </summary>
        private string FormatAsString
        {
            get { return _formatAsString; }
            set
            {
                _formatAsString = value;
                base.CustomFormat = value;
            }
        }

        /// <summary>
        /// Sets the format according to the current DateTimePickerFormat.
        /// </summary>
        private void SetFormat()
        {
            CultureInfo ci = Thread.CurrentThread.CurrentCulture;
            DateTimeFormatInfo dtf = ci.DateTimeFormat;
            switch (_format)
            {
                case DateTimePickerFormat.Long:
                    FormatAsString = dtf.LongDatePattern;
                    break;
                case DateTimePickerFormat.Short:
                    FormatAsString = dtf.ShortDatePattern;
                    break;
                case DateTimePickerFormat.Time:
                    FormatAsString = dtf.ShortTimePattern;
                    break;
                case DateTimePickerFormat.Custom:
                    FormatAsString = this.CustomFormat;
                    break;
            }
        }

        /// <summary>
        /// Sets the <b>DateTimePicker</b> to the value of the <see cref="NullValue"/> property.
        /// </summary>
        private void SetToNullValue()
        {
            _isNull = true;
            base.CustomFormat = (_nullValue == null || _nullValue == String.Empty) ? " " : "'" + _nullValue + "'";
        }

        /// <summary>
        /// Sets the <b>DateTimePicker</b> back to a non null value.
        /// </summary>
        private void SetToDateTimeValue()
        {
            if (_isNull)
            {
                SetFormat();
                _isNull = false;
                base.OnValueChanged(new EventArgs());
            }
        }
        #endregion

        #region Events
        /// <summary>
        /// This member overrides <see cref="Control.WndProc"/>.
        /// </summary>
        /// <param name="m"></param>
        protected override void WndProc(ref Message m)
        {
            if (_isNull)
            {
                if (m.Msg == 0x4e)                         // WM_NOTIFY
                {
                    NMHDR nm = (NMHDR)m.GetLParam(typeof(NMHDR));
                    if (nm.Code == -746 || nm.Code == -722)  // DTN_CLOSEUP || DTN_?
                        SetToDateTimeValue();
                }
            }
            base.WndProc(ref m);
        }

        [StructLayout(LayoutKind.Sequential)]
        private struct NMHDR
        {
            public IntPtr HwndFrom;
            public int IdFrom;
            public int Code;
        }

        /// <summary>
        /// This member overrides <see cref="Control.OnKeyDown"/>.
        /// </summary>
        /// <param name="e"></param>
        protected override void OnKeyUp(KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Delete || e.KeyCode == Keys.Back)
            {
                if (!this.PsgNotNull)
                {
                    this.Value = null;
                    OnValueChanged(EventArgs.Empty);
                }
            }

            base.OnKeyUp(e);
        }

        protected override void OnKeyPress(KeyPressEventArgs e)
        {
            if (e.KeyChar == (Char)Keys.Back)
                e.KeyChar = (Char)Keys.Delete;

            base.OnKeyPress(e);
        }

        protected override void OnValueChanged(EventArgs eventargs)
        {
            base.OnValueChanged(eventargs);
        }

        #endregion

        #region Properties

        [Category("PSG")]
        public string PsgFieldType
        {
            get { return fieldType; }
            set { fieldType = value; }
        }

        [Category("PSG")]
        public bool PsgNotNull
        {
            get { return notNull; }
            set { notNull = value; }
        }

        [Category("PSG")]
        public string PsgFieldName
        {
            get { return fieldName; }
            set
            {
                fieldName = value;
            }
        }

        [Browsable(false)]
        public DataTable Table
        {
            get { return table; }
            set { table = value; }
        }

        [Category("PSG")]
        public string PsgValueKey
        {
            get { return valueKey; }
            set { valueKey = value; }
        }

        [Category("PSG")]
        public string PsgFieldKey
        {
            get { return fieldKey; }
            set { fieldKey = value; }
        }

        [Category("PSG")]
        public string PsgServerTableName
        {
            get { return servertablename; }
            set { servertablename = value; }
        }

        [Category("PSG")]
        public bool PsgSaveType
        {
            get { return saveType; }
            set { saveType = value; }
        }

        #endregion

        private void psgDateTime_Validating(object sender, CancelEventArgs e)
        {
            if (bControl && !this.saveType)
            {
                if (string.IsNullOrEmpty(this.PsgServerTableName) ||
                    string.IsNullOrEmpty(this.PsgFieldKey) ||
                    string.IsNullOrEmpty(this.PsgFieldName) ||
                    string.IsNullOrEmpty(this.PsgFieldType))
                {
                    MessageBox.Show("PSG properties are not set. ", "Attention!");
                    return;
                }

                if (psgUpdate(sender, Base.psgIntf.GetCurrentPK(this.PsgServerTableName)))
                {
                    hmn_loop = 0;
                    while (Intf.cmdResult != PsgMsg.OK && this.hmn_loop <= 200)
                    {
                        Thread.Sleep(30);
                        this.hmn_loop = this.hmn_loop + 1;
                    }

                    if (Intf.cmdResult != PsgMsg.OK)
                    {
                        MessageBox.Show("Check server connectivity and try again!", Base.GetIntl(ConstantsBase.Attention_), MessageBoxButtons.OK);
                        this.Value = this.initial_value;

                        if (e != null)
                         e.Cancel = true;

                        Intf.cmdResult = PsgMsg.OK;

                        return;
                    }

                    if (this.Value != null && this.Value != DBNull.Value)
                        this.initial_value = (DateTime)this.Value;
                    else
                        this.initial_value = null;
                }

                View view = ((Base)this.FindForm()).view;
                if (view != null && view is ViewGrid && view.bsEditor != null)
                    view.bsEditor.EndEdit();
            }
        }
        public bool psgUpdate(object sender, string _id)
        {
            bool result;

            if (!bControl && saveType)
                return false;

            if ((Convert.ToDateTime(this.Value) != this.initial_value))
            {
                if (this.Value != null)
                {
                    string strD = this.Value.ToString().Substring(0, this.Value.ToString().IndexOf(" ")).Trim();
                    DateTime dtValue = Convert.ToDateTime(strD.ToString().Replace('.', '/'));

                    Base.kv = Base.GetParameters(_id, "C");

                    if (this.Format != DateTimePickerFormat.Short)
                    {
                        dtValue = new DateTime(dtValue.Year, dtValue.Month, dtValue.Day, DateTime.Now.Hour, DateTime.Now.Minute, DateTime.Now.Second);
                    }

                    Base.value = Base.GetParametersDateTime(dtValue);
                    Base.psgIntf.send_command("UPDATEFIELD#'" + this.PsgServerTableName + "','" + this.PsgFieldKey
                        + "'," + Base.kv + ",'" + this.PsgFieldName + "'," + Base.value);
                }
                else
                {
                    if (this.initial_value != null)
                    {
                        Base.kv = Base.GetParameters(_id, "C");
                        Base.value = Base.GetParametersDateTimeNull();
                        Base.psgIntf.send_command("UPDATEFIELD#'" + this.PsgServerTableName + "','" + this.PsgFieldKey
                            + "'," + Base.kv + ",'" + this.PsgFieldName + "'," + Base.value);
                    }
                }

                result = true;
            }
            else

                result = false;

            return result;
        }

        private void psgedit_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (bControl && !saveType)
            {
                if (e.KeyChar == Convert.ToChar(13))
                {
                    if (string.IsNullOrEmpty(this.PsgServerTableName) ||
                        string.IsNullOrEmpty(this.PsgFieldKey) ||
                        string.IsNullOrEmpty(this.PsgFieldName) ||
                        string.IsNullOrEmpty(this.PsgFieldType))
                    {
                        MessageBox.Show("PSG properties are not set. ", "Attention!");
                        return;
                    }

                    psgUpdate(sender, Base.psgIntf.GetCurrentPK(this.PsgServerTableName));
                    Base.bUpdate = false;
                    SendKeys.Send("{TAB}");
                    e.Handled = true;
                }
            }
        }
        void psgedit_Enter(object sender, EventArgs e)
        {
            this.initial_value = Convert.ToDateTime(this.Value);
            Base.bUpdate = true;
        }

        private void psgdatetime_ValueChanged(object sender, EventArgs e)
        {
            this.isNull = (this.Value == DBNull.Value);

            if (this.Focused)
            {
                if (Convert.ToDateTime(this.Value) == Utils.NullDateTime)
                    this.Value = new DateTime(Convert.ToDateTime(this.Value).Year, Convert.ToDateTime(this.Value).Month, Convert.ToDateTime(this.Value).Day);
                isModified = true;
            }


            if (this.Value == null || this.Value == DBNull.Value)
                this.Value = Utils.NullDateTime;
        }
        private void psgDateTime_DropDown(object sender, EventArgs e)
        {
        }
        private void psgDateTime_CloseUp(object sender, EventArgs e)
        {
            //if (!isModified)
            //{
            //    this.isNull = true;
            //    this.Value = DBNull.Value;
            //}
        }
    }
}
